%% Function to implement spatial sigma-delta ADC presented in []
% X - input, psi - steering angle, d -  antenna spacing (in wavelengths)
% b - quantization voltage levelfor each channel


function Y = sigma_delta_ADC_b(X,psi,d,b)
[M N] = size(X);
angle_rad = 2*pi*d*sin((psi*pi/180));
W = exp((1i*angle_rad));
Y = zeros(M,N);
err = zeros(M,N);
Y(1,:) = b(1).*sgn(X(1,:));
err(1,:) = W.*(X(1,:) - Y(1,:));
for i = 2:M
    Y(i,:) = b(i).*sgn( X(i,:) + err(i-1,:));
    err(i,:) = W.*((X(i,:) + err(i-1,:) - Y(i,:)));
end
end


% 1-bit quantizer

function x = sgn(y)

    x_re = sign(real(y));
    x_im = sign(imag(y));
    for i = 1:length(y)
        if(x_re(i) >= 0)
            x_re(i) = 1;
        end
        if(x_im(i) >= 0)
            x_im(i) = 1;
        end
    end

    x = x_re + (1i)*x_im;
end